implementation module controllayout


//	Clean Object I/O library, version 1.1

//	Control layout calculations


import	StdInt, StdBool, StdList, StdTuple, StdMisc
import	osfont, oswindow
import	commondef, controldefaccess, id, layout, windowaccess, windowhandle


controllayoutError :: String String -> .x
controllayoutError rule error
	= Error rule "controllayout" error

controllayoutFatalError :: String String -> .x
controllayoutFatalError rule error
	= FatalError rule "controllayout" error


getCompoundContentRect :: !OSWindowMetrics !Bool !Bool !Rect -> Rect
getCompoundContentRect {osmHSliderHeight,osmVSliderWidth} hasHScroll hasVScroll itemRect=:(l,t, r,b)
	| hasHScroll && hasVScroll
	= (l,t, r`,b`)
	| hasHScroll
	= (l,t, r, b`)
	| hasVScroll
	= (l,t, r`,b )
	= itemRect
where
	r`	= r-osmVSliderWidth
	b`	= b-osmHSliderHeight

getCompoundHScrollRect :: !OSWindowMetrics !Bool !Bool !Rect -> Rect
getCompoundHScrollRect {osmHSliderHeight,osmVSliderWidth} hasHScroll hasVScroll (l,t, r,b)
	| not hasHScroll
	= (0,0, 0,0)
	= (l,b`, if hasVScroll r` r,b)
where
	r`	= r-osmVSliderWidth
	b`	= b-osmHSliderHeight

getCompoundVScrollRect :: !OSWindowMetrics !Bool !Bool !Rect -> Rect
getCompoundVScrollRect {osmHSliderHeight,osmVSliderWidth} hasHScroll hasVScroll (l,t, r,b)
	| not hasVScroll
	= (0,0, 0,0)
	= (r`,t, r,if hasHScroll b` b)
where
	r`	= r-osmVSliderWidth
	b`	= b-osmHSliderHeight


getWindowContentRect :: !OSWindowMetrics !Bool !Bool !Rect -> Rect
getWindowContentRect {osmHSliderHeight,osmVSliderWidth} hasHScroll hasVScroll itemRect=:(l,t, r,b)
	| hasHScroll && hasVScroll
	= (l,t, r`,b`)
	| hasHScroll
	= (l,t, r, b`)
	| hasVScroll
	= (l,t, r`,b )
	= itemRect
where
	r`	= r-osmVSliderWidth +1
	b`	= b-osmHSliderHeight+1

getWindowHScrollRect :: !OSWindowMetrics !Bool !Bool !Rect -> Rect
getWindowHScrollRect {osmHSliderHeight,osmVSliderWidth} hasHScroll hasVScroll (l,t, r,b)
	| not hasHScroll
	= (0,0, 0,0)
	= (l-1,b`, if hasVScroll (r`+1) (r+1),b+1)
where
	r`	= r-osmVSliderWidth +1
	b`	= b-osmHSliderHeight+1

getWindowVScrollRect :: !OSWindowMetrics !Bool !Bool !Rect -> Rect
getWindowVScrollRect {osmHSliderHeight,osmVSliderWidth} hasHScroll hasVScroll (l,t, r,b)
	| not hasVScroll
	= (0,0, 0,0)
	= (r`,t-1, r+1,if hasHScroll (b`+1) (b+1))
where
	r`	= r-osmVSliderWidth +1
	b`	= b-osmHSliderHeight+1


//	Calculate the precise position (in pixels) of each Control.

layoutControls :: !OSWindowMetrics !(!Int,!Int) !(!Int,!Int) !(!Int,!Int) !Size !Size !Point !Point ![WElementHandle .ls .ps] !*OSToolbox
																						  -> (!Size,![WElementHandle .ls .ps],!*OSToolbox)
layoutControls wMetrics hMargins vMargins spaces reqSize minSize base origin itemHs tb
	# (_,_,itemHs)			= validateFirstWElementsPos False itemHs
	# (ips,_,_,_,itemHs,tb)	= WElementHandlesToItPos wMetrics hMargins vMargins spaces [] (sysId (-1)) (-2) itemHs tb
	  (size,ips)			= calcItemPositions hMargins vMargins spaces reqSize minSize origin ips
	  (_,itemHs)			= mergeItPosInWElementHandles ips itemHs
	= (size,itemHs,tb)


/*	validateFirstWElementsPos verifies that the first non line layout WElementHandle either: 
	-	already has a layout attribute, or 
	-	obtains the (Left,zero) layout attribute if not preceded by a fix or corner WItemHandle.
*/
validateFirstWElementsPos :: !Bool ![WElementHandle .ls .ps] -> (!Bool,!Bool,![WElementHandle .ls .ps])
validateFirstWElementsPos fix_corner_item_found itemHs
	| isEmpty itemHs
	= (False,fix_corner_item_found,itemHs)
	# (itemH,itemHs)						= HdTl itemHs
	  (done,fix_corner_item_found,itemH)	= validateFirstWElementPos fix_corner_item_found itemH
	| done
	= (done,fix_corner_item_found,[itemH:itemHs])
	# (done,fix_corner_item_found,itemHs)	= validateFirstWElementsPos fix_corner_item_found itemHs
	= (done,fix_corner_item_found,[itemH:itemHs])
where
	validateFirstWElementPos :: !Bool !(WElementHandle .ls .ps) -> (!Bool,!Bool,!WElementHandle .ls .ps)
	validateFirstWElementPos fix_corner_item_found (WListLSHandle itemHs)
		# (done,fix_corner_item_found,itemHs)	= validateFirstWElementsPos fix_corner_item_found itemHs
		= (done,fix_corner_item_found,WListLSHandle itemHs)
	validateFirstWElementPos fix_corner_item_found (WExtendLSHandle wExH=:{wExtendItems=itemHs})
		# (done,fix_corner_item_found,itemHs)	= validateFirstWElementsPos fix_corner_item_found itemHs
		= (done,fix_corner_item_found,WExtendLSHandle {wExH & wExtendItems=itemHs})
	validateFirstWElementPos fix_corner_item_found (WChangeLSHandle wChH=:{wChangeItems=itemHs})
		# (done,fix_corner_item_found,itemHs)	= validateFirstWElementsPos fix_corner_item_found itemHs
		= (done,fix_corner_item_found,WChangeLSHandle {wChH & wChangeItems=itemHs})
	validateFirstWElementPos fix_corner_item_found (WItemHandle itemH=:{wItemAtts})
		# (hasPos,posAtt)		= Select iscontrolpos (ControlPos (Left,zero)) wItemAtts
		| not hasPos && fix_corner_item_found
		= (True,fix_corner_item_found,WItemHandle itemH)
		| not hasPos
		= (True,fix_corner_item_found,WItemHandle {itemH & wItemAtts=[posAtt:wItemAtts]})
		# pos					= fst (getcontrolpos posAtt)
		  fix_corner_item_found	= case pos of
		  							Fix _		-> True
		  							LeftTop		-> True
		  							RightTop	-> True
		  							LeftBottom	-> True
		  							RightBottom	-> True
		  							_			-> fix_corner_item_found
		  is_line_item			= case pos of
		  							Left		-> True
		  							Right		-> True
		  							Center		-> True
		  							_			-> False
		= (is_line_item,fix_corner_item_found,WItemHandle itemH)


/*	Transform the list of WElementHandles to ItPos elements and add private information to 
	the list of WElementHandles. 
	Only the definition fields of the WElementHandle are inspected (except for the recursive
	WElementHandles (WList/WElim/WIntro/WExtend/WChange(LSHandle), and IsCompoundControls) 
	which also inspects the recursive elements). 
	The recursive ItPos-s of WList/WElim/WIntro/WExtend/WChange(LSHandle)s are flattened.
	Consequently, the resulting ItPos list can be longer than the resulting WElementHandle list!
	In case a control has no Id or an invalid Id (the Id already occurs earlier), then the control 
		is provided with a correct ControlId attribute in the attribute list. 
		The new ControlId (or the legal ControlId) attribute is placed in front of the attribute 
		list in the resulting WElementHandle list. This front position is assumed by 
		mergeItPosInWElementHandles!
	In case a control has no ControlPos attribute then it becomes (RightTo previous,zero).
*/
WElementHandlesToItPos :: OSWindowMetrics (Int,Int) (Int,Int) (Int,Int) 
									[Id] Id !Int ![WElementHandle .ls .ps] !*OSToolbox
					   -> (![ItPos],[Id],Id,!Int,![WElementHandle .ls .ps],!*OSToolbox)
WElementHandlesToItPos wMetrics hMargins vMargins spaces prevIds prevId cId [itemH:itemHs] tb
	# (itPoss1,prevIds,prevId,cId,itemH, tb) = WElementHandleToItPos  wMetrics hMargins vMargins spaces prevIds prevId cId itemH  tb
	# (itPoss2,prevIds,prevId,cId,itemHs,tb) = WElementHandlesToItPos wMetrics hMargins vMargins spaces prevIds prevId cId itemHs tb
	= (itPoss1++itPoss2,prevIds,prevId,cId,[itemH:itemHs],tb)
where
	WElementHandleToItPos :: OSWindowMetrics (Int,Int) (Int,Int) (Int,Int) 
									   [Id] Id !Int !(WElementHandle .ls .ps) !*OSToolbox
						  -> (![ItPos],[Id],Id,!Int,! WElementHandle .ls .ps, !*OSToolbox)
	WElementHandleToItPos wMetrics hMargins vMargins spaces prevIds prevId cId (WListLSHandle itemHs) tb
		# (itPoss,prevIds,prevId,cId,itemHs,tb)	= WElementHandlesToItPos wMetrics hMargins vMargins spaces prevIds prevId cId itemHs tb
		= (itPoss,prevIds,prevId,cId,WListLSHandle itemHs,tb)
	WElementHandleToItPos wMetrics hMargins vMargins spaces prevIds prevId cId (WExtendLSHandle wExH=:{wExtendItems=itemHs}) tb
		# (itPoss,prevIds,prevId,cId,itemHs,tb)	= WElementHandlesToItPos wMetrics hMargins vMargins spaces prevIds prevId cId itemHs tb
		= (itPoss,prevIds,prevId,cId,WExtendLSHandle {wExH & wExtendItems=itemHs},tb)
	WElementHandleToItPos wMetrics hMargins vMargins spaces prevIds prevId cId (WChangeLSHandle wChH=:{wChangeItems=itemHs}) tb
		# (itPoss,prevIds,prevId,cId,itemHs,tb)	= WElementHandlesToItPos wMetrics hMargins vMargins spaces prevIds prevId cId itemHs tb
		= (itPoss,prevIds,prevId,cId,WChangeLSHandle {wChH & wChangeItems=itemHs},tb)
	WElementHandleToItPos wMetrics hMargins vMargins spaces prevIds prevId cId (WItemHandle itemH) tb
		# (itPos,prevIds,prevId,cId,itemH,tb)	= WItemHandleToItPos wMetrics hMargins vMargins spaces prevIds prevId cId itemH tb
		= ([itPos],prevIds,prevId,cId,WItemHandle itemH,tb)
	where
		WItemHandleToItPos :: OSWindowMetrics (Int,Int) (Int,Int) (Int,Int) 
									  [Id] Id !Int !(WItemHandle .ls .ps) !*OSToolbox
						   -> (!ItPos,[Id],Id,!Int,! WItemHandle .ls .ps, !*OSToolbox)
		
		WItemHandleToItPos wMetrics hMargins vMargins spaces prevIds prevId cId itemH=:{wItemKind=IsButtonControl,wItemInfo,wItemAtts} tb
			# ((w,h),tb)			= OSgetButtonControlSize wMetrics itemTitle tb
			  size					= if foundSize (checkCustomSize (getcontrolsize sAtt)) {w=w,h=h}
			  itPos					= newItPos id pos size
			= (itPos,prevIds1,id,cId1,{itemH & wItemAtts=[ControlId id:wItemAtts]},tb)
		where
			pos						= attsGetItPosItemPos prevId wItemAtts
			(foundSize,sAtt)		= Select iscontrolsize (ControlSize zero) wItemAtts
			(id,cId1,prevIds1)		= getItPosId cId itemH.wItemId prevIds
			itemTitle				= (getWItemButtonInfo wItemInfo).buttonInfoText
		
		WItemHandleToItPos wMetrics hMargins vMargins spaces prevIds prevId cId itemH=:{wItemKind=IsCustomButtonControl,wItemAtts} tb
			= (itPos,prevIds1,id,cId1,{itemH & wItemAtts=[ControlId id:wItemAtts]},tb)
		where
			pos						= attsGetItPosItemPos prevId wItemAtts
			size					= getcontrolsize (snd (Select iscontrolsize (ControlSize zero) wItemAtts))
			(id,cId1,prevIds1)		= getItPosId cId itemH.wItemId prevIds
			itPos					= newItPos id pos (checkCustomSize size)
		
		WItemHandleToItPos wMetrics hMargins vMargins spaces prevIds prevId cId itemH=:{wItemKind=IsTextControl,wItemInfo,wItemAtts} tb
			# ((w,h),tb)			= OSgetTextControlSize wMetrics itemTitle tb
			  size					= if foundSize (checkCustomSize (getcontrolsize sAtt)) {w=w,h=h}
			  itPos					= newItPos id pos size
			= (itPos,prevIds1,id,cId1,{itemH & wItemAtts=[ControlId id:wItemAtts]},tb)
		where
			(foundSize,sAtt)		= Select iscontrolsize undef wItemAtts
			pos						= attsGetItPosItemPos prevId wItemAtts
			(id,cId1,prevIds1)		= getItPosId cId itemH.wItemId prevIds
			itemTitle				= (getWItemTextInfo wItemInfo).textInfoText
		
		WItemHandleToItPos wMetrics hMargins vMargins spaces prevIds prevId cId itemH=:{wItemKind=IsEditControl,wItemInfo,wItemAtts} tb
			# ((w,h),tb)			= OSgetEditControlSize wMetrics info.editInfoWidth info.editInfoNrLines tb
			  itPos					= newItPos id pos (checkCustomSize {w=w,h=h})
			= (itPos,prevIds1,id,cId1,{itemH & wItemAtts=[ControlId id:wItemAtts]},tb)
		where
			info					= getWItemEditInfo wItemInfo
			(id,cId1,prevIds1)		= getItPosId cId itemH.wItemId prevIds
			pos						= attsGetItPosItemPos prevId wItemAtts
		
		WItemHandleToItPos wMetrics hMargins vMargins spaces prevIds prevId cId itemH=:{wItemKind=IsPopUpControl,wItemInfo,wItemAtts} tb
			| isEmpty popUps
			= controllayoutError "PopUpControl definition" "Empty list of PopUpItem-s"
			# ((w,h),tb)			= OSgetPopUpControlSize wMetrics (map fst info.popUpInfoItems) tb
			  itPos					= newItPos id pos {w=w,h=h}
			= (itPos,prevIds1,id,cId1,{itemH & wItemAtts=[ControlId id:wItemAtts]},tb)
		where
			info					= getWItemPopUpInfo wItemInfo
			popUps					= info.popUpInfoItems
			(id,cId1,prevIds1)		= getItPosId cId itemH.wItemId prevIds
			pos						= attsGetItPosItemPos prevId wItemAtts
		
		WItemHandleToItPos wMetrics hMargins vMargins spaces prevIds prevId cId itemH=:{wItemKind=IsRadioControl,wItemInfo,wItemAtts} tb
			| isEmpty items
			= controllayoutError "RadioControl definition" "Empty list of RadioItem-s"
			# (itemsizes,tb)		= StateMap (radioboxsize wMetrics) items tb
			  colitemsizes			= toColumns layout itemsizes
			  colwidths				= map (map (\{radioItemSize={w}}->w)) colitemsizes
			  colmaxwidths			= map listmax colwidths
			  width					= sum colmaxwidths
			  height				= itemHeight*(length (hd colwidths))
			  itPos					= newItPos id pos {w=width,h=height}
			  collaynoutitems		= position_items itemHeight 0 colmaxwidths colitemsizes
			  laynoutitems			= fromColumns layout collaynoutitems
			  info					= RadioInfo {info & radioItems=laynoutitems}
			= (itPos,prevIds1,id,cId1,{itemH & wItemAtts=[ControlId id:wItemAtts],wItemInfo=info},tb)
		where
			pos						= attsGetItPosItemPos prevId wItemAtts
			(id,cId1,prevIds1)		= getItPosId cId itemH.wItemId prevIds
			itemHeight				= OSgetRadioControlItemHeight wMetrics
			info					= getWItemRadioInfo wItemInfo
			items					= info.radioItems
			layout					= info.radioLayout
			
			radioboxsize :: !OSWindowMetrics !(RadioItemInfo .ps) !*OSToolbox -> (!RadioItemInfo .ps,!*OSToolbox)
			radioboxsize wMetrics item=:{radioItem=(title,_)} tb
				# ((w,h),tb)		= OSgetRadioControlItemSize wMetrics title tb
				= ({item & radioItemSize={w=w,h=h}},tb)
			
			position_items :: !Int !Int ![Int] ![[RadioItemInfo .ps]] -> [[RadioItemInfo .ps]]
			position_items itemHeight left [maxwidth:maxwidths] [col:cols]
				# col	= position_items` itemHeight {x=left,y=0} col
				  cols	= position_items  itemHeight (left+maxwidth) maxwidths cols
				= [col:cols]
			where
				position_items` :: !Int !Point ![RadioItemInfo .ps] -> [RadioItemInfo .ps]
				position_items` itemHeight pos [item:items]
					= [{item & radioItemPos=pos}:position_items` itemHeight {pos & y=pos.y+itemHeight} items]
				position_items` _ _ _
					= []
			position_items _ _ _ _
				= []
		
		WItemHandleToItPos wMetrics hMargins vMargins spaces prevIds prevId cId itemH=:{wItemKind=IsCheckControl,wItemInfo,wItemAtts} tb
			| isEmpty items
			= controllayoutError "CheckControl definition" "Empty list of CheckItem-s"
			# (itemsizes,tb)		= StateMap (checkboxsize wMetrics) items tb
			  colitemsizes			= toColumns layout itemsizes
			  colwidths				= map (map (\{checkItemSize={w}}->w)) colitemsizes
			  colmaxwidths			= map listmax colwidths
			  width					= sum colmaxwidths
			  height				= itemHeight*(length (hd colwidths))
			  itPos					= newItPos id pos {w=width,h=height}
			  collaynoutitems		= position_items itemHeight 0 colmaxwidths colitemsizes
			  laynoutitems			= fromColumns layout collaynoutitems
			  info					= CheckInfo {info & checkItems=laynoutitems}
			= (itPos,prevIds1,id,cId1,{itemH & wItemAtts=[ControlId id:wItemAtts],wItemInfo=info},tb)
		where
			pos						= attsGetItPosItemPos prevId wItemAtts
			(id,cId1,prevIds1)		= getItPosId cId itemH.wItemId prevIds
			itemHeight				= OSgetCheckControlItemHeight wMetrics
			info					= getWItemCheckInfo wItemInfo
			items					= info.checkItems
			layout					= info.checkLayout
			
			checkboxsize :: !OSWindowMetrics !(CheckItemInfo .ps) !*OSToolbox -> (!CheckItemInfo .ps,!*OSToolbox)
			checkboxsize wMetrics item=:{checkItem=(title,_,_)} tb
				# ((w,h),tb)		= OSgetCheckControlItemSize wMetrics title tb
				= ({item & checkItemSize={w=w,h=h}},tb)
			
			position_items :: !Int !Int ![Int] ![[CheckItemInfo .ps]] -> [[CheckItemInfo .ps]]
			position_items itemHeight left [maxwidth:maxwidths] [col:cols]
				# col	= position_items` itemHeight {x=left,y=0} col
				  cols	= position_items  itemHeight (left+maxwidth) maxwidths cols
				= [col:cols]
			where
				position_items` :: !Int !Point ![CheckItemInfo .ps] -> [CheckItemInfo .ps]
				position_items` itemHeight pos [item:items]
					= [{item & checkItemPos=pos}:position_items` itemHeight {pos & y=pos.y+itemHeight} items]
				position_items` _ _ _
					= []
			position_items _ _ _ _
				= []
		
		WItemHandleToItPos wMetrics hMargins vMargins spaces prevIds prevId cId itemH=:{wItemKind=IsCustomControl,wItemAtts} tb
			= (itPos,prevIds1,id,cId1,{itemH & wItemAtts=[ControlId id:wItemAtts]},tb)
		where
			size					= getcontrolsize (snd (Select iscontrolsize (ControlSize zero) wItemAtts))
			(id,cId1,prevIds1)		= getItPosId cId itemH.wItemId prevIds
			pos						= attsGetItPosItemPos prevId wItemAtts
			itPos					= newItPos id pos (checkCustomSize size)
		
		WItemHandleToItPos wMetrics hMargins vMargins spaces prevIds prevId cId itemH=:{wItemKind=IsSliderControl,wItemInfo,wItemAtts} tb
			= (itPos,prevIds1,id,cId1,{itemH & wItemAtts=[ControlId id:wItemAtts]},tb)
		where
			(id,cId1,prevIds1)		= getItPosId cId itemH.wItemId prevIds
			pos						= attsGetItPosItemPos prevId wItemAtts
			info					= getWItemSliderInfo wItemInfo
			(w,h)					= OSgetSliderControlSize wMetrics (info.sliderInfoDir==Horizontal) info.sliderInfoLength
			itPos					= newItPos id pos {w=w,h=h}
		
		WItemHandleToItPos wMetrics hMargins vMargins spaces prevIds prevId cId itemH=:{wItemKind=IsOtherControl _,wItemAtts} tb
			= (itPos,prevIds1,id,cId1,{itemH & wItemAtts=[ControlId id:wItemAtts]},tb)
		where
			(id,cId1,prevIds1)		= getItPosId cId itemH.wItemId prevIds
			pos						= attsGetItPosItemPos prevId wItemAtts
			size					= getcontrolsize (snd (Select iscontrolsize (ControlSize zero) wItemAtts))
			itPos					= newItPos id pos (checkCustomSize size)
		
		WItemHandleToItPos wMetrics hMargins vMargins spaces prevIds prevId cId itemH=:{wItemKind=IsCompoundControl,wItemInfo,wItemAtts,wItems} tb
			= (itPos,prevIds1,id,cId1,{itemH & wItemAtts=[ControlId id:atts1],wItems=items,wItemInfo=CompoundInfo info1},tb1)
		where
			info					= getWItemCompoundInfo wItemInfo
			(size,info1,items,atts1,tb1)
									= calcCompoundSize wMetrics hMargins vMargins spaces info wItems wItemAtts tb
			(id,cId1,prevIds1)		= getItPosId cId itemH.wItemId prevIds
			pos						= attsGetItPosItemPos prevId wItemAtts
			itPos					= newItPos id pos size
			
			calcCompoundSize :: !OSWindowMetrics !(!Int,!Int) !(!Int,!Int) !(!Int,!Int)
									  !CompoundInfo ![WElementHandle .ls .ps] ![ControlAttribute (.ls,.ps)] !*OSToolbox
							-> (!Size,!CompoundInfo,![WElementHandle .ls .ps],![ControlAttribute (.ls,.ps)],!*OSToolbox)
			calcCompoundSize wMetrics hMargins=:(lMargin,rMargin) vMargins=:(tMargin,bMargin) spaces info itemHs atts tb
				= (okDerivedSize,info1,itemHs1,if hadSize atts1 [ControlSize okDerivedSize:atts1],tb1)
			where
				(minSize,atts1)			= validateMinSize atts
				(hadSize,reqSize)		= validateSize minSize atts1
				(_,hMarginAtt)			= Select iscontrolhmargin (ControlHMargin lMargin rMargin) atts1
				newHMargins				= validateControlMargin (getcontrolhmargin hMarginAtt)
				(_,vMarginAtt)			= Select iscontrolvmargin (ControlVMargin tMargin bMargin) atts1
				newVMargins				= validateControlMargin (getcontrolvmargin vMarginAtt)
				(_,spaceAtt)			= Select iscontrolitemspace (ControlItemSpace (fst spaces) (snd spaces)) atts1
				newItemSpaces			= validateControlItemSpace (getcontrolitemspace spaceAtt)
				domain					= info.compoundDomain
				base					= domain.corner1
				origin					= info.compoundOrigin
				(derSize,itemHs1,tb1)	= layoutControls wMetrics newHMargins newVMargins newItemSpaces reqSize minSize base origin itemHs tb
				okDerivedSize			= validateDerivedSize wMetrics info derSize reqSize
				info1					= layoutScrollbars wMetrics okDerivedSize info

				validateMinSize :: ![ControlAttribute .ps] -> (!Size,![ControlAttribute .ps])
				validateMinSize atts
					= (okMinSize,if hadMinSize [ControlMinimumSize okMinSize:atts1] atts1)
				where
					(defMinW,defMinH)			= OSMinCompoundSize
					(hadMinSize,minAtt,atts1)	= Remove iscontrolminimumsize (ControlMinimumSize {w=defMinW,h=defMinH}) atts
					minSize						= getcontrolminimumsize minAtt
					okMinSize					= {w=max defMinW minSize.w,h=max defMinH minSize.h}
				
				validateSize :: !Size ![ControlAttribute .ps] -> (!Bool,!Size)
				validateSize minSize atts
					=	(hadSize,if hadSize okSize zero)
				where
					(hadSize,sAtt)		= Select iscontrolsize undef atts
					size				= getcontrolsize sAtt
					okSize				= {w=max size.w minSize.w,h=max size.h minSize.h}
				
				validateDerivedSize :: !OSWindowMetrics !CompoundInfo Size !Size -> Size
				validateDerivedSize wMetrics info derSize reqSize
					| reqSize==zero
					= validateScrollbarSize wMetrics domain (hasHScroll,hasVScroll) derSize
					= validateScrollbarSize wMetrics domain (hasHScroll,hasVScroll) reqSize
				where
					hasHScroll	= isJust info.compoundHScroll
					hasVScroll	= isJust info.compoundVScroll
					domain		= info.compoundDomain
					
					validateScrollbarSize :: !OSWindowMetrics !ViewDomain !(!Bool,!Bool) !Size -> Size
					validateScrollbarSize wMetrics domain (hasHScroll,hasVScroll) size=:{w,h}
						| domainSize==zero
						= size
						| visHScroll && visVScroll
						= {w=w`,h=h`}
						| visHScroll
						= {size & h=h`}
						| visVScroll
						= {size & w=w`}
						= size
					where
						domainSize				= rectangleSize domain
						domainRect				= RectangleToRect domain
						(visHScroll,visVScroll)	= OSscrollbarsAreVisible wMetrics domainRect (w,h) (hasHScroll,hasVScroll)
						w`						= w+wMetrics.osmVSliderWidth
						h`						= h+wMetrics.osmHSliderHeight
				
				validateControlMargin :: !(!Int,!Int) -> (!Int,!Int)
				validateControlMargin (a,b) = (max 0 a,max 0 b)
				
				validateControlItemSpace :: !(!Int,!Int) -> (!Int,!Int)
				validateControlItemSpace (hspace,vspace) = (max 0 hspace,max 0 vspace)
				
				layoutScrollbars :: !OSWindowMetrics !Size !CompoundInfo -> CompoundInfo
				layoutScrollbars wMetrics size info=:{compoundHScroll,compoundVScroll}
					= {	info & compoundHScroll=layoutScrollbar hRect compoundHScroll
							 , compoundVScroll=layoutScrollbar vRect compoundVScroll
					  }
				where
					hasHScroll	= isJust compoundHScroll
					hasVScroll	= isJust compoundVScroll
					rect		= SizeToRect size
					hRect		= getCompoundHScrollRect wMetrics hasHScroll hasVScroll rect
					vRect		= getCompoundVScrollRect wMetrics hasHScroll hasVScroll rect
					
					layoutScrollbar :: Rect !(Maybe ScrollInfo) -> Maybe ScrollInfo
					layoutScrollbar rect maybeScrollInfo
						| isNothing maybeScrollInfo
						= maybeScrollInfo
						# (l,t,r,b)	= rect
						  scrollInfo= fromJust maybeScrollInfo
						  scrollInfo= {scrollInfo & scrollItemPos={x=l,y=t},scrollItemSize={w=r-l,h=b-t}}
						= Just scrollInfo

		WItemHandleToItPos _ _ _ _ _ _ _ _ _
			= controllayoutFatalError "WItemHandleToItPos" "unmatched control implementation alternative"
		
		getItPosId :: !Int !(Maybe Id) [Id] -> (Id,Int,[Id])
		getItPosId cId opt_id prevIds
			| isNothing opt_id
			= (sysId cId,cId-1,prevIds)
			| isMember id prevIds
			= (sysId cId,cId-1,prevIds)
			= (id,		 cId,  [id:prevIds])
		where
			id	= fromJust opt_id
		
		attsGetItPosItemPos :: Id ![ControlAttribute .ps] -> ItemPos
		attsGetItPosItemPos prevId atts
			= (itemLoc1,offset)
		where
			(itemLoc,offset)	= getcontrolpos (snd (Select iscontrolpos (ControlPos (RightTo prevId,zero)) atts))
			itemLoc1			= if (isRelativeToPrev itemLoc) (setRelativeTo prevId itemLoc) itemLoc
			
			isRelativeToPrev :: !ItemLoc -> Bool
			isRelativeToPrev itemLoc = itemLoc==LeftOfPrev || itemLoc==RightToPrev || itemLoc==AbovePrev || itemLoc==BelowPrev
			
			setRelativeTo :: !Id !ItemLoc -> ItemLoc
			setRelativeTo id LeftOfPrev		= LeftOf	id
			setRelativeTo id RightToPrev	= RightTo	id
			setRelativeTo id AbovePrev		= Above		id
			setRelativeTo id BelowPrev		= Below		id
		
		checkCustomSize :: Size -> Size
		checkCustomSize {w,h} = {w=max 0 w,h=max 0 h}
	
	toColumns :: !RowsOrColumns ![x] -> [[x]]
	toColumns (Columns n) items
		= repeat_splitting perColumn items
	where
		nrItems		= length items
		n`			= max 1 n
		perColumn	= if (nrItems rem n`==0) (nrItems/n`) (nrItems/n`+1)
		
		repeat_splitting :: !Int ![x] -> [[x]]
		repeat_splitting n items
			# (before,after) = Split n items
			| isEmpty after
			= [before]
			= [before:repeat_splitting n after]
	toColumns (Rows n) items
		= repeat_spreading nrColumns items cols
	where
		nrItems		= length items
		n`			= SetBetween n 1 nrItems
		nrColumns	= if (nrItems rem n`==0) (nrItems/n`) (nrItems/n`+1)
		cols		= repeatn nrColumns []
		
		repeat_spreading :: !Int ![x] ![[x]] -> [[x]]
		repeat_spreading n items cols
			# (before,after) = Split n items
			| isEmpty after
			= spread before cols
			= spread before (repeat_spreading n after cols)
		where
			spread :: ![.x] ![[.x]] -> [[.x]]
			spread [x:xs] [ys:zs]
				= [[x:ys]:spread xs zs]
			spread [] zs
				= zs
	
	fromColumns :: !RowsOrColumns ![[x]] -> [x]
	fromColumns (Columns _) items
		= flatten items
	fromColumns (Rows _) items
		= repeat_collecting items
	where
		repeat_collecting :: ![[x]] -> [x]
		repeat_collecting items
			# (before,after) = collect items
			| isEmpty after
			= before
			= before++repeat_collecting after
		where
			collect :: ![[x]] -> (![x],![[x]])
			collect [[x:xs]:ys]
				# (zs,ys)	= collect ys
				= ([x:zs],[xs:ys])
			collect _
				= ([],[])
	
	listmax :: ![Int] -> Int
	listmax [x:xs]	= foldr max x xs
	listmax _		= 0
WElementHandlesToItPos _ _ _ _ prevIds prevId cId [] tb
	= ([],prevIds,prevId,cId,[],tb)


/*	After positioning/rentering the elements, the calculated control positions and sizes must be added 
	to the original WElementHandle list. 
	In case of recursive WElementHandles (WList/WElim/WIntro/WExtend/WChange(LSHandle), and CompoundControls) 
	the recursively calculated positions must also be added.
	In case of (Radio/Check)Controls the already calculated (radio/check) control positions that are
	oriented at base zero need to be shifted to the calculated base position of the (Radio/Check)Control. 
	
	Note that mergeItPosInWElementHandles relies on the fact that the hd element of the attribute
	list contains the ControlId attribute, used for computing the layout (as provided by
	WElementHandlesToItPos)! It will remove this element from the attribute list.
*/
mergeItPosInWElementHandles :: ![ItPos] ![WElementHandle .ls .ps] -> (![ItPos],![WElementHandle .ls .ps])
mergeItPosInWElementHandles itPoss [itemH:itemHs]
	# (itPoss,itemH)	= mergeItPosInWElementHandle  itPoss itemH
	# (itPoss,itemHs)	= mergeItPosInWElementHandles itPoss itemHs
	= (itPoss,[itemH:itemHs])
where
	mergeItPosInWElementHandle :: ![ItPos] !(WElementHandle .ls .ps) -> (![ItPos],!WElementHandle .ls .ps)
	mergeItPosInWElementHandle itPoss (WListLSHandle itemHs)
		# (itPoss,itemHs)	= mergeItPosInWElementHandles itPoss itemHs
		= (itPoss,WListLSHandle itemHs)
	mergeItPosInWElementHandle itPoss (WExtendLSHandle wExH=:{wExtendItems=itemHs})
		# (itPoss,itemHs)	= mergeItPosInWElementHandles itPoss itemHs
		= (itPoss,WExtendLSHandle {wExH & wExtendItems=itemHs})
	mergeItPosInWElementHandle itPoss (WChangeLSHandle wChH=:{wChangeItems=itemHs})
		# (itPoss,itemHs)	= mergeItPosInWElementHandles itPoss itemHs
		= (itPoss,WChangeLSHandle {wChH & wChangeItems=itemHs})
	mergeItPosInWElementHandle itPoss (WItemHandle itemH)
		# (itPoss,itemH)	= mergeItPosInWItemHandle itPoss itemH
		= (itPoss,WItemHandle itemH)
	where
		mergeItPosInWItemHandle :: ![ItPos] !(WItemHandle .ls .ps) -> (![ItPos],!WItemHandle .ls .ps)
		mergeItPosInWItemHandle itPoss itemH=:{wItemKind,wItemInfo,wItems,wItemAtts=[ControlId id:atts]}
			# (isFixedPos,corner,size,offset,itPoss)
											= ipRemoveIdRect id itPoss
			  itemHs						= if (wItemKind==IsCompoundControl) (map (shiftCompounds offset) wItems) wItems
			  info							= shiftWItemInfo offset wItemInfo
			= (	itPoss
			  ,	{	itemH	& wItemAtts		= atts
							, wItemInfo		= info
							, wItems		= itemHs
							, wItemPos		= corner
							, wItemFixedPos	= isFixedPos
							, wItemSize		= size
				}
			  )
		where
			shiftCompounds :: !ItemOffset !(WElementHandle .ls .ps) -> WElementHandle .ls .ps
			shiftCompounds offset (WListLSHandle itemHs)
				= WListLSHandle (map (shiftCompounds offset) itemHs)
			shiftCompounds offset (WExtendLSHandle wExH=:{wExtendItems=itemHs})
				= WExtendLSHandle {wExH & wExtendItems=map (shiftCompounds offset) itemHs}
			shiftCompounds offset (WChangeLSHandle wChH=:{wChangeItems=itemHs})
				= WChangeLSHandle {wChH & wChangeItems=map (shiftCompounds offset) itemHs}
			shiftCompounds offset (WItemHandle itemH)
				= WItemHandle (shiftCompound offset itemH)
			where
				shiftCompound :: !ItemOffset !(WItemHandle .ls .ps) -> WItemHandle .ls .ps
				shiftCompound offset itemH=:{wItemKind,wItemInfo,wItemPos,wItemFixedPos,wItems}
					= {	itemH &	wItemPos	= addPointVector offset wItemPos
							  ,	wItems		= if (wItemKind==IsCompoundControl) (map (shiftCompounds offset) wItems) wItems
							  ,	wItemInfo	= shiftWItemInfo offset wItemInfo
					  }
			
			shiftWItemInfo :: !ItemOffset !(WItemInfo .ls .ps) -> WItemInfo .ls .ps
			shiftWItemInfo offset (CheckInfo info=:{checkItems})
				= CheckInfo {info & checkItems=map shiftCheckItem checkItems}
			where
				shiftCheckItem :: !(CheckItemInfo .ps) -> CheckItemInfo .ps
				shiftCheckItem item=:{checkItemPos}
					= {item & checkItemPos=addPointVector offset checkItemPos}
			shiftWItemInfo offset (RadioInfo info=:{radioItems})
				= RadioInfo {info & radioItems=map shiftRadioItem radioItems}
			where
				shiftRadioItem :: !(RadioItemInfo .ps) -> RadioItemInfo .ps
				shiftRadioItem item=:{radioItemPos}
					= {item & radioItemPos=addPointVector offset radioItemPos}
			shiftWItemInfo offset (CompoundInfo info=:{compoundHScroll,compoundVScroll})
				= CompoundInfo {info & compoundHScroll=shiftScrollbar compoundHScroll
									 , compoundVScroll=shiftScrollbar compoundVScroll
							   }
			where
				shiftScrollbar :: !(Maybe ScrollInfo) -> Maybe ScrollInfo
				shiftScrollbar Nothing
					= Nothing
				shiftScrollbar (Just info=:{scrollItemPos})
					= Just {info & scrollItemPos=addPointVector offset scrollItemPos}
			shiftWItemInfo _ info
				= info
		mergeItPosInWItemHandle _ _
			= controllayoutFatalError "mergeItPosInWItemHandle" "WElementHandle has no ControlId"
mergeItPosInWElementHandles itPoss itemHs
	= (itPoss,itemHs)
